'use strict'

const openModal = () => document.getElementById('modal')
    .classList.add('active')

const closeModal = () => {
    clearFields()
    document.getElementById('modal').classList.remove('active')
}


const getProdutos = () => {
    var  token = localStorage.getItem("token");
    let request = new XMLHttpRequest()
    request.open("GET", "https://www.emporiovarejo.com.br/apis/crud/emporiovarejo", false);
    request.setRequestHeader('Authorization', 'Bearer ' + token);
    request.send()
    //return auth
    return request.responseText
}

const getJwt = () => {
    var name = ''
    var password =''
    var token = ''
    $.ajax({
      type: 'POST',
      url: 'https://www.emporiovarejo.com.br/apis/crud/u/login',
      data: { email: 'eckzbr@gmail.com' , pass: 'senha123' },
      success: function(res){
        var token = res.jwt;
        console.log(token);
        localStorage.setItem("token", token)
      }
    });
};

//const getLocalStorage = () => JSON.parse(getProdutos())
const getLocalStorage = () => JSON.parse(localStorage.getItem('db_client')) ?? [{codigo: "EMPVRJ00001", descricao: "", emuso: false}, 
{codigo: "EMPVRJ00002", descricao: "", emuso: false}, 
{codigo: "EMPVRJ00003", descricao: "", emuso: false}, 
{codigo: "EMPVRJ00004", descricao: "", emuso: false}, 
{codigo: "EMPVRJ00005", descricao: "", emuso: false}, 
{codigo: "EMPVRJ00006", descricao: "", emuso: false}, 
{codigo: "EMPVRJ00007", descricao: "", emuso: false}, 
{codigo: "EMPVRJ00008", descricao: "", emuso: false}, 
{codigo: "EMPVRJ00009", descricao: "", emuso: false}, 
{codigo: "EMPVRJ00010", descricao: "", emuso: false}, 
{codigo: "EMPVRJ00011", descricao: "", emuso: false}, 
{codigo: "EMPVRJ00012", descricao: "", emuso: false}, 
{codigo: "EMPVRJ00013", descricao: "", emuso: false}, 
{codigo: "EMPVRJ00014", descricao: "", emuso: false}, 
{codigo: "EMPVRJ00015", descricao: "", emuso: false}, 
{codigo: "EMPVRJ00016", descricao: "", emuso: false}, 
{codigo: "EMPVRJ00017", descricao: "", emuso: false}, 
{codigo: "EMPVRJ00018", descricao: "", emuso: false}, 
{codigo: "EMPVRJ00019", descricao: "", emuso: false}, 
{codigo: "EMPVRJ00020", descricao: "", emuso: false}, 
{codigo: "EMPVRJ00021", descricao: "", emuso: false}, 
{codigo: "EMPVRJ00022", descricao: "", emuso: false}, 
{codigo: "EMPVRJ00023", descricao: "", emuso: false}, 
{codigo: "EMPVRJ00024", descricao: "", emuso: false}, 
{codigo: "EMPVRJ00025", descricao: "", emuso: false}, 
{codigo: "EMPVRJ00026", descricao: "", emuso: false}, 
{codigo: "EMPVRJ00027", descricao: "", emuso: false}, 
{codigo: "EMPVRJ00028", descricao: "", emuso: false}, 
{codigo: "EMPVRJ00029", descricao: "", emuso: false}, 
{codigo: "EMPVRJ00030", descricao: "", emuso: false}, 
{codigo: "EMPVRJ00031", descricao: "", emuso: false}, 
{codigo: "EMPVRJ00032", descricao: "", emuso: false}, 
{codigo: "EMPVRJ00033", descricao: "", emuso: false}, 
{codigo: "EMPVRJ00034", descricao: "", emuso: false}, 
{codigo: "EMPVRJ00035", descricao: "", emuso: false}, 
{codigo: "EMPVRJ00036", descricao: "", emuso: false}, 
{codigo: "EMPVRJ00037", descricao: "", emuso: false}, 
{codigo: "EMPVRJ00038", descricao: "", emuso: false}, 
{codigo: "EMPVRJ00039", descricao: "", emuso: false}, 
{codigo: "EMPVRJ00040", descricao: "", emuso: false}, 
{codigo: "EMPVRJ00041", descricao: "", emuso: false}, 
{codigo: "EMPVRJ00042", descricao: "", emuso: false}, 
{codigo: "EMPVRJ00043", descricao: "", emuso: false}, 
{codigo: "EMPVRJ00044", descricao: "", emuso: false}, 
{codigo: "EMPVRJ00045", descricao: "", emuso: false}, 
{codigo: "EMPVRJ00046", descricao: "", emuso: false}, 
{codigo: "EMPVRJ00047", descricao: "", emuso: false}, 
{codigo: "EMPVRJ00048", descricao: "", emuso: false}, 
{codigo: "EMPVRJ00049", descricao: "", emuso: false}, 
{codigo: "EMPVRJ00050", descricao: "", emuso: false}, 
{codigo: "EMPVRJ00051", descricao: "", emuso: false}, 
{codigo: "EMPVRJ00052", descricao: "", emuso: false}, 
{codigo: "EMPVRJ00053", descricao: "", emuso: false}, 
{codigo: "EMPVRJ00054", descricao: "", emuso: false}, 
{codigo: "EMPVRJ00055", descricao: "", emuso: false}, 
{codigo: "EMPVRJ00056", descricao: "", emuso: false}, 
{codigo: "EMPVRJ00057", descricao: "", emuso: false}, 
{codigo: "EMPVRJ00058", descricao: "", emuso: false}, 
{codigo: "EMPVRJ00059", descricao: "", emuso: false}, 
{codigo: "EMPVRJ00060", descricao: "", emuso: false}, 
{codigo: "EMPVRJ00061", descricao: "", emuso: false}, 
{codigo: "EMPVRJ00062", descricao: "", emuso: false}, 
{codigo: "EMPVRJ00063", descricao: "", emuso: false}, 
{codigo: "EMPVRJ00064", descricao: "", emuso: false}, 
{codigo: "EMPVRJ00065", descricao: "", emuso: false}, 
{codigo: "EMPVRJ00066", descricao: "", emuso: false}, 
{codigo: "EMPVRJ00067", descricao: "", emuso: false}, 
{codigo: "EMPVRJ00068", descricao: "", emuso: false}, 
{codigo: "EMPVRJ00069", descricao: "", emuso: false}, 
{codigo: "EMPVRJ00070", descricao: "", emuso: false}, 
{codigo: "EMPVRJ00071", descricao: "", emuso: false}, 
{codigo: "EMPVRJ00072", descricao: "", emuso: false}, 
{codigo: "EMPVRJ00073", descricao: "", emuso: false}, 
{codigo: "EMPVRJ00074", descricao: "", emuso: false}, 
{codigo: "EMPVRJ00075", descricao: "", emuso: false}, 
{codigo: "EMPVRJ00076", descricao: "", emuso: false}, 
{codigo: "EMPVRJ00077", descricao: "", emuso: false}, 
{codigo: "EMPVRJ00078", descricao: "", emuso: false}, 
{codigo: "EMPVRJ00079", descricao: "", emuso: false}, 
{codigo: "EMPVRJ00080", descricao: "", emuso: false}, 
{codigo: "EMPVRJ00081", descricao: "", emuso: false}, 
{codigo: "EMPVRJ00082", descricao: "", emuso: false}, 
{codigo: "EMPVRJ00083", descricao: "", emuso: false}, 
{codigo: "EMPVRJ00084", descricao: "", emuso: false}, 
{codigo: "EMPVRJ00085", descricao: "", emuso: false}, 
{codigo: "EMPVRJ00086", descricao: "", emuso: false}, 
{codigo: "EMPVRJ00087", descricao: "", emuso: false}, 
{codigo: "EMPVRJ00088", descricao: "", emuso: false}, 
{codigo: "EMPVRJ00089", descricao: "", emuso: false}, 
{codigo: "EMPVRJ00090", descricao: "", emuso: false}, 
{codigo: "EMPVRJ00091", descricao: "", emuso: false}, 
{codigo: "EMPVRJ00092", descricao: "", emuso: false}, 
{codigo: "EMPVRJ00093", descricao: "", emuso: false}, 
{codigo: "EMPVRJ00094", descricao: "", emuso: false}, 
{codigo: "EMPVRJ00095", descricao: "", emuso: false}, 
{codigo: "EMPVRJ00096", descricao: "", emuso: false}, 
{codigo: "EMPVRJ00097", descricao: "", emuso: false}, 
{codigo: "EMPVRJ00098", descricao: "", emuso: false}, 
{codigo: "EMPVRJ00099", descricao: "", emuso: false}, 
{codigo: "EMPVRJ00100", descricao: "", emuso: false}
]
const setLocalStorage = (dbClient) => localStorage.setItem("db_client", JSON.stringify(dbClient))

// CRUD - create read update delete
const deleteClient = (index) => {
    const dbClient = readClient()
    dbClient.splice(index, 1)
    setLocalStorage(dbClient)
}

const updateClient = (index, client) => {
    const dbClient = readClient()
    dbClient[index] = client
    setLocalStorage(dbClient)
}

const readClient = () => getLocalStorage()

const createClient = (client) => {
    const dbClient = getLocalStorage()
    dbClient.push (client)
    setLocalStorage(dbClient)
}

const isValidFields = () => {
    return document.getElementById('form').reportValidity()
}

//Interação com o layout

const clearFields = () => {
    const fields = document.querySelectorAll('.modal-field')
    fields.forEach(field => field.value = "")
    document.getElementById('codigo').dataset.index = 'new'
}

const saveClient = () => {
    debugger
    if (isValidFields()) {
        const client = {
            codigo: document.getElementById('codigo').value,
            descricao: document.getElementById('descricao').value,
            emuso: document.getElementById('emuso').checked,
        }
        const index = document.getElementById('codigo').dataset.index
        if (index == 'new') {
            createClient(client)
            updateTable()
            closeModal()
        } else {
            updateClient(index, client)
            updateTable()
            closeModal()
        }
    }
}

const createRow = (client, index) => {
    const newRow = document.createElement('tr')
    newRow.innerHTML = `
        <td>${client.codigo}</td>
        <td>${client.descricao}</td>
        <td>${client.emuso ? 'Em uso' : 'Fora de uso'}</td>
        <td>
            <button type="button" class="button green" id="edit-${index}">Editar</button>
            <button type="button" class="button red" id="delete-${index}" >Excluir</button>
        </td>
    `
    document.querySelector('#tableClient>tbody').appendChild(newRow)
}

const clearTable = () => {
    const rows = document.querySelectorAll('#tableClient>tbody tr')
    rows.forEach(row => row.parentNode.removeChild(row))
}

const updateTable = () => {
    const dbClient = readClient()
    clearTable()
    dbClient.forEach(createRow)
}

const fillFields = (client) => {
    document.getElementById('codigo').value = client.codigo
    document.getElementById('descricao').value = client.descricao
    document.getElementById('emuso').checked = client.emuso
    document.getElementById('codigo').dataset.index = client.index
}

const editClient = (index) => {
    const client = readClient()[index]
    client.index = index
    fillFields(client)
    openModal()
}

const editDelete = (event) => {
    if (event.target.type == 'button') {

        const [action, index] = event.target.id.split('-')

        if (action == 'edit') {
            editClient(index)
        } else {
            const client = readClient()[index]
            const response = confirm(`Deseja realmente excluir o produto ${client.codigo}`)
            if (response) {
                deleteClient(index)
                updateTable()
            }
        }
    }
}

updateTable()

// Eventos
document.getElementById('cadastrarCliente')
    .addEventListener('click', openModal)

document.getElementById('modalClose')
    .addEventListener('click', closeModal)

document.getElementById('salvar')
    .addEventListener('click', saveClient)

document.querySelector('#tableClient>tbody')
    .addEventListener('click', editDelete)

document.getElementById('cancelar')
    .addEventListener('click', closeModal)